PrefabFiles = {
	"mayoi","saribackpack"
}

Assets = {
    
    Asset( "IMAGE", "images/saveslot_portraits/mayoi.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/mayoi.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/mayoi.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/mayoi.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/mayoi_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/mayoi_silho.xml" ),

    Asset( "IMAGE", "bigportraits/mayoi.tex" ),
    Asset( "ATLAS", "bigportraits/mayoi.xml" ),
       
Asset( "IMAGE", "images/inventoryimages/saribackpack.tex" ),
    Asset( "ATLAS", "images/inventoryimages/saribackpack.xml" ),
	
	
	Asset( "IMAGE", "images/map_icons/mayoi.tex" ),
	Asset( "ATLAS", "images/map_icons/mayoi.xml" ),	
Asset( "IMAGE", "images/map_icons/saribackpack.tex" ),
	Asset( "ATLAS", "images/map_icons/saribackpack.xml" ),	

Asset("SOUNDPACKAGE", "sound/mayoi.fev"),
    Asset("SOUND", "sound/mayoi.fsb"),

       
}

local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local TECH = GLOBAL.TECH
local require = GLOBAL.require


GLOBAL.STRINGS.NAMES.SARIBACKPACK = "Mayoi's  backpack"
GLOBAL.STRINGS.RECIPE_DESC.SARIBACKPACK = "A big bag"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SARIBACKPACK = "It is so heavy"
GLOBAL.STRINGS.CHARACTER_TITLES.mayoi = "Mayoi"
GLOBAL.STRINGS.CHARACTER_NAMES.mayoi = "mayoi" 
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.mayoi = "*She is just a little girl\n*Always lost way\n* Has a big backpack"
GLOBAL.STRINGS.CHARACTER_QUOTES.mayoi = "\"Maybe I lost my way again\""
GLOBAL.STRINGS.CHARACTERS.MAYOI = require "speech_mayoi"

local function MayoiMaxwellIntro(inst)
    if GLOBAL.GetPlayer().prefab == "mayoi" then
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
		delay = 0,
            appearsound = "dontstarve/maxwell/appear_adventure",
	    voice = "dontstarve/maxwell/talk_LP",
		appearanim = "appear",
		idleanim= "idle",
		dialogpreanim = "dialog_pre",
		dialoganim="dial_loop",
		dialogpostanim = "dialog_pst",
		disappearanim = "disappear",
            disableplayer = true,
            skippable = false,
            {
                string = "Oh,a cute girl.",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "Welcome to my world,little girl.",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "But it's not a good place for holiday.",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "Yon'd better go home  before dark.",
                wait = 3,
                anim = nil,
		sound = "dontstarve/HUD/collect_resource", 
            },
            {
                string = "that's a good girl.",
                wait = 3,
                anim = nil,
                sound = nil,
            },
	}

        inst.components.maxwelltalker.speeches.ADVENTURE_1 =
        {
		delay = 2,
            appearsound = "dontstarve/maxwell/appear_adventure",
	    voice = "dontstarve/maxwell/talk_LP_world2",
		appearanim = "appear2",
		idleanim= "idle2_loop",
		dialogpreanim = "dialog2_pre",
		dialoganim="dialog2_loop",
		dialogpostanim = "dialog2_pst",
		disappearanim = "disappear2",
            disableplayer = true,
            skippable = false,
            {
			string = "How can you be here.",
			wait = 2,
			anim = nil,
			sound = nil,
		},
		{
			string = "This place isn't safe for you.", 
			wait = 2, 
			anim = nil, 
			sound = nil,
		},
		{
			string = "Your mother will be sad ", 
			wait = 3, 
			anim = nil, 
			sound = nil, 
		},
		{
			string = "You'd better go home right now.", 
			wait = 2, 
			anim = nil, 
			sound = nil, 
		},
		{
			string = "What a stubborn girl.", 
			wait = 2, 
			anim = nil, 
			sound = "dontstarve/HUD/collect_resource", 
		},
		{
			string = "Just take care of yourself.", 
			wait = 2, 
			anim = nil, 
			sound = nil, 
		},
	}

        inst.components.maxwelltalker.speeches.ADVENTURE_2 =
	{		
		delay = 2,
	    voice = "dontstarve/maxwell/talk_LP_world3",
		appearanim = "appear3",
		idleanim= "idle3_loop",
		dialogpreanim = "dialog3_pre",
		dialoganim="dialog3_loop",
		dialogpostanim = "dialog3_pst",
		disappearanim = "disappear3",
		disableplayer = true,
		skippable = true,
		{
			string = "You're still here?",
			wait = 2,
			anim = nil,
			sound = nil,
		},
		{
			string = "If they find you here, they might kill you!", 
			wait = 2, 
			anim = nil, 
			sound = nil,
		},
		{
			string = "Please, just listen to me.", 
			wait = 2, 
			anim = nil, 
			sound = nil,
		},
	}

        inst.components.maxwelltalker.speeches.ADVENTURE_TWOLANDS =
	{		
		delay = 2,
	    voice = "dontstarve/maxwell/talk_LP_world4",
		appearanim = "appear4",
		idleanim= "idle4_loop",
		dialogpreanim = "dialog4_pre",
		dialoganim="dialog4_loop",
		dialogpostanim = "dialog4_pst",
		disappearanim = "disappear4",
		disableplayer = true,
		skippable = true,
		{
			string = "Stop the travel.",
			wait = 1,
			anim = nil,
			sound = nil,
		},
		{
			string = "That's not funny at all", 
			wait = 2, 
			anim = nil, 
			sound = nil,
		},
		{
			string = "You ignore every word I say, don't you?", 
			wait = 2, 
			anim = nil, 
			sound = nil,
		},
		{
			string = "That's it! You'll get a lesson.", 
			wait = 3, 
			anim = nil, 
			sound = nil,
		},
	}

        inst.components.maxwelltalker.speeches.ADVENTURE_4 =
	{		
		delay = 2,
	    voice = "dontstarve/maxwell/talk_LP_world4",
		appearanim = "appear4",
		idleanim= "idle4_loop",
		dialogpreanim = "dialog4_pre",
		dialoganim="dialog4_loop",
		dialogpostanim = "dialog4_pst",
		disappearanim = "disappear4",
		disableplayer = true,
		skippable = true,
		{
			string = "I looked down on you....",
			wait = 1,
			anim = nil,
			sound = nil,
		},
		{
			string = "...What a naughty girl.", 
			wait = 2, 
			anim = nil, 
			sound = nil,
		},
		{
			string = "You ignore every word I say, don't you?", 
			wait = 2, 
			anim = nil, 
			sound = nil,
		},
		{
			string = "I don't welcome you now!", 
			wait = 3, 
			anim = nil, 
			sound = nil,
		},
	}

        inst.components.maxwelltalker.speeches.ADVENTURE_5 =
	{		
		delay = 2,
	    voice = "dontstarve/maxwell/talk_LP_world5",
		appearanim = "appear5",
		idleanim= "idle5_loop",
		dialogpreanim = "dialog5_pre",
		dialoganim="dialog5_loop",
		dialogpostanim = "dialog5_pst",
		disappearanim = "disappear5",
		disableplayer = true,
		skippable = true,
		{
			string = "I said you must go home!",
			wait = 2,
			anim = nil,
			sound = nil,
		},
		{
			string = "Listen to me when I talk to you!", 
			wait = 2.5, 
			anim = nil, 
			sound = nil,
		},
		{
			string = "You are nothing but wasted time!", 
			wait = 3, 
			anim = nil, 
			sound = nil,
		},
		{
			string = "Nothing but a failiure!", 
			wait = 2.5, 
			anim = nil, 
			sound = nil,
		},
	}

    end
end

local require = GLOBAL.require
 
AddPrefabPostInit("maxwellintro", MayoiMaxwellIntro)



local function makePostInit(custom_inv)
	return function (inst)
		setStarterInventory(inst, custom_inv)
	end
end



function AddMap(inst)
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( inst.prefab .. ".tex" )
end      



AddMinimapAtlas("images/inventoryimages/saribackpack.xml")
AddMinimapAtlas("images/map_icons/mayoi.xml")
AddModCharacter("mayoi")

RemapSoundEvent( "dontstarve/characters/mayoi/death_voice", "mayoi/characters/mayoi/death_voice" )
RemapSoundEvent( "dontstarve/characters/mayoi/hurt", "mayoi/characters/mayoi/hurt" )
RemapSoundEvent( "dontstarve/characters/mayoi/talk_LP", "mayoi/characters/mayoi/talk_LP" )